#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "Domino HTTP server exposes the set up of the filesystem";
 name["francais"] = "Le serveur HTTP Domino affiche la config du filesystem";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
It is possible to get the absolute path leading to
the remote /cgi-bin directory by requesting a bogus
cgi (like : 'GET /cgi-bin/blah').

This problem can be used to obtain OS and installation
details.

Solution : Contact your vendor for a patch
Risk factor : Low";


 desc["francais"] = "
Il est possible d'obtenir le chemin absolu menant
au dossier cgi-bin en faisant une requete pour un CGI
bidon (tel que 'GET /cgi-bin/blah').

Ce problme peut etre exploit pour obtenir des dtails
sur votre OS et votre installation.

Solution : Contactez votre vendeur pour un patch
Facteur de risque : faible";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "obtains absolute path to cgi-bin";
 summary["francais"] = "obtient le chemin vers cgi-bin";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;

if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  req = string("GET /cgi-bin/just_a_test_ignore HTTP/1.0\r\n\r\n");
  send(socket:soc, data:req);
  s = recv(socket:soc, length:2048);
  if("domino/cgi-bin" >< s)security_warning(port);
  close(soc);
 }
}
