#!/bin/bash -
# libguestfs
# Copyright (C) 2016 Red Hat Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

# Regression test for:
# https://bugzilla.redhat.com/show_bug.cgi?id=1370424
# Handle a network disk without a port attribute.

set -e

$TEST_FUNCTIONS
skip_if_skipped
skip_if_backend uml

guestfish <<EOF
-add-domain rhbz1370424 \
            libvirturi:test://$(pwd)/rhbz1370424.xml \
            readonly:true
# The test is just that the above command does not segfault.
# We don't need to do anything else here.
EOF
