/*
 * Seven Kingdoms: Ancient Adversaries
 *
 * Copyright 1997,1998 Enlight Software Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

//Filename    : OUNITAAT.CPP
//Description : Object UnitArray - table for attacking

#include <OUNIT.h>

#ifdef NO_DEBUG_UNIT
#undef err_when
#undef err_here
#undef err_if
#undef err_else
#undef err_now
#define err_when(cond)
#define err_here()
#define err_if(cond)
#define err_else
#define err_now(msg)
#undef DEBUG
#endif


//------------------------------------------------------------------------------//
// the codes in this file is used to return a pair of offset.  Adding the offsets
// with a target location, the attacker can find a suitable space to attack the
// target.
//------------------------------------------------------------------------------//

static char attack_x_offset11[ATTACK_DIR][8] // target size 1x1
=	{	{ -1, -1, -1,  0,  0,  1,  1,  1},
		{ -1,  0, -1,  1, -1,  1,  0,  1},
		{  0,  1, -1,  1, -1,  1, -1,  0},
		{  1,  1,  0,  1, -1,  0, -1, -1},
		{  1,  1,  1,  0,  0, -1, -1, -1},
		{  1,  0,  1, -1,  1, -1,  0, -1},
		{  0, -1,  1, -1,  1, -1,  1,  0},
		{ -1, -1,  0, -1,  1,  0,  1,  1}};
static char attack_x_offset12[ATTACK_DIR][10] // target size 1x2
=	{	{ -1, -1, -1, -1,  0,  0,  1,  1,  1,  1},
		{ -1, -1,  0, -1,  1, -1,  1,  0,  1,  1},
		{  0,  1, -1,  1, -1,  1, -1,  1, -1,  0},
		{  1,  1,  0,  1, -1,  1, -1,  0, -1, -1},
		{  1,  1,  1,  1,  0,  0, -1, -1, -1, -1},
		{  1,  1,  0,  1, -1,  1, -1,  0, -1, -1},
		{  0, -1,  1, -1,  1, -1,  1, -1,  1,  0},
		{ -1, -1,  0, -1,  1, -1,  1,  0,  1,  1}};
static char attack_x_offset13[ATTACK_DIR][12] // target size 1x3
=	{	{ -1, -1, -1, -1, -1,  0,  0,  1,  1,  1,  1,  1},
		{ -1, -1,  0, -1,  1, -1,  1, -1,  1,  0,  1,  1},
		{  0,  1, -1,  1, -1,  1, -1,  1, -1,  1, -1,  0},
		{  1,  1,  0,  1, -1,  1, -1,  1, -1,  0, -1, -1},
		{  1,  1,  1,  1,  1,  0,  0, -1, -1, -1, -1, -1},
		{  1,  1,  0,  1, -1,  1, -1,  1, -1,  0, -1, -1},
		{  0, -1,  1, -1,  1, -1,  1, -1,  1, -1,  1,  0},
		{ -1, -1,  0, -1,  1, -1,  1, -1,  1,  0,  1,  1}};
static char attack_x_offset14[ATTACK_DIR][14] // target size 1x4
=	{	{ -1, -1, -1, -1, -1, -1,  0,  0,  1,  1,  1,  1,  1,  1},
		{ -1, -1,  0, -1,  1, -1,  1, -1,  1, -1,  1,  0,  1,  1},
		{  0,  1, -1,  1, -1,  1, -1,  1, -1,  1, -1,  1, -1,  0},
		{  1,  1,  0,  1, -1,  1, -1,  1, -1,  1, -1,  0, -1, -1},
		{  1,  1,  1,  1,  1,  1,  0,  0, -1, -1, -1, -1, -1, -1},
		{  1,  1,  0,  1, -1,  1, -1,  1, -1,  1, -1,  0, -1, -1},
		{  0, -1,  1, -1,  1, -1,  1, -1,  1, -1,  1, -1,  1,  0},
		{ -1, -1,  0, -1,  1, -1,  1, -1,  1, -1,  1,  0,  1,  1}};
static char attack_x_offset21[ATTACK_DIR][10] // target size 2x1
=	{	{ -1, -1, -1,  0,  0,  1,  1,  2,  2,  2},
		{ -1,  0, -1,  1, -1,  2,  0,  2,  1,  2},
		{  0,  1, -1,  2, -1,  2, -1,  2,  0,  1},
		{  2,  1,  2,  0,  2, -1,  1, -1,  0, -1},
		{  2,  2,  2,  1,  1,  0,  0, -1, -1, -1},
		{  2,  1,  2,  0,  2, -1,  1, -1,  0, -1},
		{  0,  1, -1,  2, -1,  2, -1,  2,  0,  1},
		{ -1,  0, -1,  1, -1,  2,  0,  2,  1,  2}};
static char attack_x_offset22[ATTACK_DIR][12] // target size 2x2
=	{	{ -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  2,  2},
		{ -1,  0, -1,  1, -1,  2, -1,  2,  0,  2,  1,  2},
		{  0,  1, -1,  2, -1,  2, -1,  2, -1,  2,  0,  1},
		{  2,  2,  1,  2,  0,  2, -1,  1, -1,  0, -1, -1}, 
		{  2,  2,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1},
		{  2,  1,  2,  0,  2, -1,  2, -1,  1, -1,  0, -1},
		{  1,  0,  2, -1,  2, -1,  2, -1,  2, -1,  1,  0},
		{ -1, -1,  0, -1,  1, -1,  2,  0,  2,  1,  2,  2}};
static char attack_x_offset23[ATTACK_DIR][14] // target size 2x3
=	{	{ -1, -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  2,  2,  2},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  2,  0,  2,  1,  2,  2},
		{  0,  1, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2,  0,  1},
		{  2,  2,  1,  2,  0,  2, -1,  2, -1,  1, -1,  0, -1, -1},
		{  2,  2,  2,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1, -1},
		{  2,  2,  1,  2,  0,  2, -1,  2, -1,  1, -1,  0, -1, -1},
		{  0,  1, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2,  0,  1},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  2,  0,  2,  1,  2,  2}};
static char attack_x_offset24[ATTACK_DIR][16] // target size 2x4
=	{	{ -1, -1, -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  2,  2,  2,  2},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  2, -1,  2,  0,  2,  1,  2,  2},
		{  0,  1, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2,  0,  1},
		{  2,  2,  1,  2,  0,  2, -1,  2, -1,  2, -1,  1, -1,  0, -1, -1},
		{  2,  2,  2,  2,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1, -1, -1},
		{  2,  2,  1,  2,  0,  2, -1,  2, -1,  2, -1,  1, -1,  0, -1, -1},
		{  0,  1, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2,  0,  1},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  2, -1,  2,  0,  2,  1,  2,  2}};
static char attack_x_offset31[ATTACK_DIR][12] // target size 3x1
=	{	{ -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  3},
		{ -1,  0, -1,  1, -1,  2,  0,  3,  1,  3,  2,  3},
		{  1,  2,  0,  3, -1,  3, -1,  3, -1,  2,  0,  1},
		{  3,  2,  3,  1,  3,  0,  2, -1,  1, -1,  0, -1},
		{  3,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1},
		{  3,  2,  3,  1,  3,  0,  2, -1,  1, -1,  0, -1},
		{  1,  0,  2, -1,  3, -1,  3, -1,  3,  0,  2,  1},
		{ -1,  0, -1,  1, -1,  2,  0,  3,  1,  3,  2,  3}};
static char attack_x_offset32[ATTACK_DIR][14] // target size 3x2
=	{	{ -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  3,  3},
		{ -1,  0, -1,  1, -1,  2, -1,  3,  0,  3,  1,  3,  2,  3},
		{  1,  2,  0,  3, -1,  3, -1,  3, -1,  3, -1,  2,  0,  1},
		{  3,  2,  3,  1,  3,  0,  3, -1,  2, -1,  1, -1,  0, -1},
		{  3,  3,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1},
		{  3,  2,  3,  1,  3,  0,  3, -1,  2, -1,  1, -1,  0, -1},
		{  1,  0,  2, -1,  3, -1,  3, -1,  3, -1,  3,  0,  2,  1},
		{ -1,  0, -1,  1, -1,  2, -1,  3,  0,  3,  1,  3,  2,  3}};
static char attack_x_offset33[ATTACK_DIR][16] // target size 3x3
=	{	{ -1, -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  3,  3,  3},
		{ -1,  0, -1,  1, -1,  2, -1,  3, -1,  3,  0,  3,  1,  3,  2,  3},
		{  1,  2,  0,  3, -1,  3, -1,  3, -1,  3, -1,  3, -1,  2,  0,  1},
		{  3,  3,  2,  3,  1,  3,  0,  3, -1,  2, -1,  1, -1,  0, -1, -1},
		{  3,  3,  3,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1, -1},
		{  3,  2,  3,  1,  3,  0,  3, -1,  3, -1,  2, -1,  1, -1,  0, -1},
		{  1,  0,  2, -1,  3, -1,  3, -1,  3, -1,  3, -1,  3,  0,  2,  1},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  3,  0,  3,  1,  3,  2,  3,  3}};
static char attack_x_offset34[ATTACK_DIR][18] // target size 3x4
=	{	{ -1, -1, -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  3,  3,  3,  3},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  3, -1,  3,  0,  3,  1,  3,  2,  3,  3},
		{  1,  2,  0,  3, -1,  3, -1,  3, -1,  3, -1,  3, -1,  3, -1,  2,  0,  1},
		{  3,  3,  2,  3,  1,  3,  0,  3, -1,  3, -1,  2, -1,  1, -1,  0, -1, -1},
		{  3,  3,  3,  3,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1, -1, -1},
		{  3,  3,  2,  3,  1,  3,  0,  3, -1,  3, -1,  2, -1,  1, -1,  0, -1, -1},
		{  1,  0,  2, -1,  3, -1,  3, -1,  3, -1,  3, -1,  3, -1,  3,  0,  2,  1},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  3, -1,  3,  0,  3,  1,  3,  2,  3,  3}};
static char attack_x_offset41[ATTACK_DIR][14] // target size 4x1
=	{	{ -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  4},
		{ -1,  0, -1,  1, -1,  2,  0,  3,  1,  4,  2,  4,  3,  4},
		{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{  4,  3,  4,  2,  4,  1,  3,  0,  2, -1,  1, -1,  0, -1},
		{  4,  4,  4,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1},
		{  4,  3,  4,  2,  4,  1,  3,  0,  2, -1,  1, -1,  0, -1},
		{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{ -1,  0, -1,  1, -1,  2,  0,  3,  1,  4,  2,  4,  3,  4}};
static char attack_x_offset42[ATTACK_DIR][16] // target size 4x2
= {	{ -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  4,  4},
		{ -1,  0, -1,  1, -1,  2, -1,  3,  0,  4,  1,  4,  2,  4,  3,  4},
		{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{  4,  3,  4,  2,  4,  1,  4,  0,  3, -1,  2, -1,  1, -1,  0, -1},
		{  4,  4,  4,  4,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1},
		{  4,  3,  4,  2,  4,  1,  4,  0,  3, -1,  2, -1,  1, -1,  0, -1},
		{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{ -1,  0, -1,  1, -1,  2, -1,  3,  0,  4,  1,  4,  2,  4,  3,  4}};
static char attack_x_offset43[ATTACK_DIR][18] // target size 4x3
=	{	{ -1, -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  4,  4,  4},
		{ -1,  0, -1,  1, -1,  2, -1,  3, -1,  4,  0,  4,  1,  4,  2,  4,  3,  4},
		{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{  4,  3,  4,  2,  4,  1,  4,  0,  4, -1,  3, -1,  2, -1,  1, -1,  0, -1},
		{  4,  4,  4,  4,  4,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1, -1},
		{  4,  3,  4,  2,  4,  1,  4,  0,  4, -1,  3, -1,  2, -1,  1, -1,  0, -1},
		{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{ -1,  0, -1,  1, -1,  2, -1,  3, -1,  4,  0,  4,  1,  4,  2,  4,  3,  4}};
static char attack_x_offset44[ATTACK_DIR][20] // target size 4x4
=	{	{ -1, -1, -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  4,  4,  4,  4},
		{ -1,  0, -1,  1, -1,  2, -1,  3, -1,  4, -1,  4,  0,  4,  1,  4,  2,  4,  3,  4},
		{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{  4,  4,  3,  4,  2,  4,  1,  4,  0,  4, -1,  3, -1,  2, -1,  1, -1,  0, -1, -1},
		{  4,  4,  4,  4,  4,  4,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1, -1, -1},
		{  4,  3,  4,  2,  4,  1,  4,  0,  4, -1,  4, -1,  3, -1,  2, -1,  1, -1,  0, -1},
		{  2,  1,  3,  0,  4, -1,  4, -1,  4, -1,  4, -1,  4, -1,  4, -1,  3,  0,  2,  1},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  3, -1,  4,  0,  4,  1,  4,  2,  4,  3,  4,  4}};

static char attack_y_offset11[ATTACK_DIR][8] // target size 1x1
=	{	{  0,  1, -1,  1, -1,  1, -1,  0},
		{  1,  1,  0,  1, -1,  0, -1, -1},
		{  1,  1,  1,  0,  0, -1, -1, -1},
		{  1,  0,  1, -1,  1, -1,  0, -1},
		{  0, -1,  1, -1,  1, -1,  1,  0},
		{ -1, -1,  0, -1,  1,  0,  1,  1},
		{ -1, -1, -1,  0,  0,  1,  1,  1},
		{ -1,  0, -1,  1, -1,  1,  0,  1}};
static char attack_y_offset12[ATTACK_DIR][10] // target size 1x2
=	{	{  0,  1, -1,  2, -1,  2, -1,  2,  0,  1},
		{  2,  1,  2,  0,  2, -1,  1, -1,  0, -1},
		{  2,  2,  2,  1,  1,  0,  0, -1, -1, -1},
		{  2,  1,  2,  0,  2, -1,  1, -1,  0, -1},
		{  0,  1, -1,  2, -1,  2, -1,  2,  0,  1},
		{ -1,  0, -1,  1, -1,  2,  0,  2,  1,  2},
		{ -1, -1, -1,  0,  0,  1,  1,  2,  2,  2},
		{ -1,  0, -1,  1, -1,  2,  0,  2,  1,  2}};
static char attack_y_offset13[ATTACK_DIR][12] // target size 1x3
=	{	{  1,  2,  0,  3, -1,  3, -1,  3, -1,  2,  0,  1},
		{  3,  2,  3,  1,  3,  0,  2, -1,  1, -1,  0, -1},
		{  3,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1},
		{  3,  2,  3,  1,  3,  0,  2, -1,  1, -1,  0, -1},
		{  1,  0,  2, -1,  3, -1,  3, -1,  3,  0,  2,  1},
		{ -1,  0, -1,  1, -1,  2,  0,  3,  1,  3,  2,  3},
		{ -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  3},
		{ -1,  0, -1,  1, -1,  2,  0,  3,  1,  3,  2,  3}};
static char attack_y_offset14[ATTACK_DIR][14] // target size 1x4
=	{	{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{  4,  3,  4,  2,  4,  1,  3,  0,  2, -1,  1, -1,  0, -1},
		{  4,  4,  4,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1},
		{  4,  3,  4,  2,  4,  1,  3,  0,  2, -1,  1, -1,  0, -1},
		{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{ -1,  0, -1,  1, -1,  2,  0,  3,  1,  4,  2,  4,  3,  4},
		{ -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  4},
		{ -1,  0, -1,  1, -1,  2,  0,  3,  1,  4,  2,  4,  3,  4}};
static char attack_y_offset21[ATTACK_DIR][10] // target size 2x1
=	{	{  0,  1, -1,  1, -1,  1, -1,  1, -1,  0},
		{  1,  1,  0,  1, -1,  1, -1,  0, -1, -1},
		{  1,  1,  1,  1,  0,  0, -1, -1, -1, -1},
		{  1,  1,  0,  1, -1,  1, -1,  0, -1, -1},
		{  0, -1,  1, -1,  1, -1,  1, -1,  1,  0},
		{ -1, -1,  0, -1,  1, -1,  1,  0,  1,  1},
		{ -1, -1, -1, -1,  0,  0,  1,  1,  1,  1},
		{ -1, -1,  0, -1,  1, -1,  1,  0,  1,  1}};
static char attack_y_offset22[ATTACK_DIR][12] // target size 2x2
=	{	{  0,  1, -1,  2, -1,  2, -1,  2, -1,  2,  0,  1},
		{  2,  2,  1,  2,  0,  2, -1,  1, -1,  0, -1, -1},
		{  2,  2,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1},
		{  2,  1,  2,  0,  2, -1,  2, -1,  1, -1,  0, -1},
		{  1,  0,  2, -1,  2, -1,  2, -1,  2, -1,  1,  0},
		{ -1, -1,  0, -1,  1, -1,  2,  0,  2,  1,  2,  2},
		{ -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  2,  2},
		{ -1,  0, -1,  1, -1,  2, -1,  2,  0,  2,  1,  2}};
static char attack_y_offset23[ATTACK_DIR][14] // target size 2x3
=	{	{  1,  2,  0,  3, -1,  3, -1,  3, -1,  3, -1,  2,  0,  1},
		{  3,  2,  3,  1,  3,  0,  3, -1,  2, -1,  1, -1,  0, -1},
 		{  3,  3,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1},
		{  3,  2,  3,  1,  3,  0,  3, -1,  2, -1,  1, -1,  0, -1},
		{  1,  0,  2, -1,  3, -1,  3, -1,  3, -1,  3,  0,  2,  1},
		{ -1,  0, -1,  1, -1,  2, -1,  3,  0,  3,  1,  3,  2,  3},
		{ -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  3,  3},
		{ -1,  0, -1,  1, -1,  2, -1,  3,  0,  3,  1,  3,  2,  3}};
static char attack_y_offset24[ATTACK_DIR][16] // target size 2x4
=	{	{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{  4,  3,  4,  2,  4,  1,  4,  0,  3, -1,  2, -1,  1, -1,  0, -1},
		{  4,  4,  4,  4,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1},
 		{  4,  3,  4,  2,  4,  1,  4,  0,  3, -1,  2, -1,  1, -1,  0, -1},
		{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{ -1,  0, -1,  1, -1,  2, -1,  3,  0,  4,  1,  4,  2,  4,  3,  4},
		{ -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  4,  4},
		{ -1,  0, -1,  1, -1,  2, -1,  3,  0,  4,  1,  4,  2,  4,  3,  4}};
static char attack_y_offset31[ATTACK_DIR][12] // target size 3x1
=	{	{  0,  1, -1,  1, -1,  1, -1,  1, -1,  1, -1,  0},
		{  1,  1,  0,  1, -1,  1, -1,  1, -1,  0, -1, -1},
		{  1,  1,  1,  1,  1,  0,  0, -1, -1, -1, -1, -1},
		{  1,  1,  0,  1, -1,  1, -1,  1, -1,  0, -1, -1},
		{  0, -1,  1, -1,  1, -1,  1, -1,  1, -1,  1,  0},
		{ -1, -1,  0, -1,  1, -1,  1, -1,  1,  0,  1,  1},
		{ -1, -1, -1, -1, -1,  0,  0,  1,  1,  1,  1,  1},
		{ -1, -1,  0, -1,  1, -1,  1, -1,  1,  0,  1,  1}};
static char attack_y_offset32[ATTACK_DIR][14] // target size 3x2
=	{	{  0,  1, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2,  0,  1},
		{  2,  2,  1,  2,  0,  2, -1,  2, -1,  1, -1,  0, -1, -1},
		{  2,  2,  2,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1, -1},
		{  2,  2,  1,  2,  0,  2, -1,  2, -1,  1, -1,  0, -1, -1},
		{  0,  1, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2,  0,  1},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  2,  0,  2,  1,  2,  2},
		{ -1, -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  2,  2,  2},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  2,  0,  2,  1,  2,  2}};
static char attack_y_offset33[ATTACK_DIR][16] // target size 3x3
=	{	{  1,  2,  0,  3, -1,  3, -1,  3, -1,  3, -1,  3, -1,  2,  0,  1},
		{  3,  3,  2,  3,  1,  3,  0,  3, -1,  2, -1,  1, -1,  0, -1, -1},
		{  3,  3,  3,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1, -1},
		{  3,  2,  3,  1,  3,  0,  3, -1,  3, -1,  2, -1,  1, -1,  0, -1},
		{  1,  0,  2, -1,  3, -1,  3, -1,  3, -1,  3, -1,  3,  0,  2,  1},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  3,  0,  3,  1,  3,  2,  3,  3},
		{ -1, -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  3,  3,  3},
		{ -1,  0, -1,  1, -1,  2, -1,  3, -1,  3,  0,  3,  1,  3,  2,  3}};
static char attack_y_offset34[ATTACK_DIR][18] // target size 3x4
=	{	{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{  4,  3,  4,  2,  4,  1,  4,  0,  4, -1,  3, -1,  2, -1,  1, -1,  0, -1},
 		{  4,  4,  4,  4,  4,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1, -1},
		{  4,  3,  4,  2,  4,  1,  4,  0,  4, -1,  3, -1,  2, -1,  1, -1,  0, -1},
		{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{ -1,  0, -1,  1, -1,  2, -1,  3, -1,  4,  0,  4,  1,  4,  2,  4,  3,  4},
		{ -1, -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  4,  4,  4},
		{ -1,  0, -1,  1, -1,  2, -1,  3, -1,  4,  0,  4,  1,  4,  2,  4,  3,  4}};
static char attack_y_offset41[ATTACK_DIR][14] // target size 4x1
=	{	{  0,  1, -1,  1, -1,  1, -1,  1, -1,  1, -1,  1, -1,  0},
		{  1,  1,  0,  1, -1,  1, -1,  1, -1,  1, -1,  0, -1, -1},
		{  1,  1,  1,  1,  1,  1,  0,  0, -1, -1, -1, -1, -1, -1},
		{  1,  1,  0,  1, -1,  1, -1,  1, -1,  1, -1,  0, -1, -1},
		{  0, -1,  1, -1,  1, -1,  1, -1,  1, -1,  1, -1,  1,  0},
		{ -1, -1,  0, -1,  1, -1,  1, -1,  1, -1,  1,  0,  1, -1},
		{ -1, -1, -1, -1, -1, -1,  0,  0,  1,  1,  1,  1,  1,  1},
		{ -1, -1,  0, -1,  1, -1,  1, -1,  1, -1,  1,  0,  1,  1}};
static char attack_y_offset42[ATTACK_DIR][16] // target size 4x2
=	{	{  0,  1, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2,  0,  1},
		{  2,  2,  1,  2,  0,  2, -1,  2, -1,  2, -1,  1, -1,  0, -1, -1},
		{  2,  2,  2,  2,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1, -1, -1},
		{  2,  2,  1,  2,  0,  2, -1,  2, -1,  2, -1,  1, -1,  0, -1, -1},
		{  0,  1, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2,  0,  1},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  2, -1,  2,  0,  2,  1,  2,  2},
		{ -1, -1, -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  2,  2,  2,  2},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  2, -1,  2,  0,  2,  1,  2,  2}};
static char attack_y_offset43[ATTACK_DIR][18] // target size 4x3
=	{	{  1,  2,  0,  3, -1,  3, -1,  3, -1,  3, -1,  3, -1,  3, -1,  2,  0,  1},
		{  3,  3,  2,  3,  1,  3,  0,  3, -1,  3, -1,  2, -1,  1, -1,  0, -1, -1},
		{  3,  3,  3,  3,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1, -1, -1},
		{  3,  3,  2,  3,  1,  3,  0,  3, -1,  3, -1,  2, -1,  1, -1,  0, -1, -1},
		{  1,  0,  2, -1,  3, -1,  3, -1,  3, -1,  3, -1,  3, -1,  3,  0,  2,  1},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  3, -1,  3,  0,  3,  1,  3,  2,  3,  3},
		{ -1, -1, -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  3,  3,  3,  3},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  3, -1,  3,  0,  3,  1,  3,  2,  3,  3}};
static char attack_y_offset44[ATTACK_DIR][20] // target size 4x4
=	{	{  1,  2,  0,  3, -1,  4, -1,  4, -1,  4, -1,  4, -1,  4, -1,  4,  0,  3,  1,  2},
		{  4,  4,  3,  4,  2,  4,  1,  4,  0,  4, -1,  3, -1,  2, -1,  1, -1,  0, -1, -1},
		{  4,  4,  4,  4,  4,  4,  3,  3,  2,  2,  1,  1,  0,  0, -1, -1, -1, -1, -1, -1},
		{  4,  3,  4,  2,  4,  1,  4,  0,  4, -1,  4, -1,  3, -1,  2, -1,  1, -1,  0, -1},
		{  2,  1,  3,  0,  4, -1,  4, -1,  4, -1,  4, -1,  4, -1,  4, -1,  3,  0,  2,  1},
		{ -1, -1,  0, -1,  1, -1,  2, -1,  3, -1,  4,  0,  4,  1,  4,  2,  4,  3,  4,  4},
		{ -1, -1, -1, -1, -1, -1,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  4,  4,  4,  4},
		{ -1,  0, -1,  1, -1,  2, -1,  3, -1,  4, -1,  4,  0,  4,  1,  4,  2,  4,  3,  4}};

//--------- Begin of function UnitArray::get_target_x_offset ---------//
// return x offset
//
// <int>		targetWidth		- width of the target
// <int>		targetHeight	- height of the target
//	<char>	curDir			- the direction of attacker to the target
//
char* UnitArray::get_target_x_offset(int targetWidth, int targetHeight, char curDir)
{
	err_when(curDir<0 || curDir>ATTACK_DIR);
	int targetType = targetWidth*10 + targetHeight;
	switch(targetType)
	{
		case 11:	return attack_x_offset11[curDir];
		case 12:	return attack_x_offset12[curDir];
		case 13:	return attack_x_offset13[curDir];
		case 14:	return attack_x_offset14[curDir];
		case 21:	return attack_x_offset21[curDir];
		case 22:	return attack_x_offset22[curDir];
		case 23:	return attack_x_offset23[curDir];
		case 24:	return attack_x_offset24[curDir];
		case 31:	return attack_x_offset31[curDir];
		case 32:	return attack_x_offset32[curDir];
		case 33:	return attack_x_offset33[curDir];
		case 34:	return attack_x_offset34[curDir];
		case 41:	return attack_x_offset41[curDir];
		case 42:	return attack_x_offset42[curDir];
		case 43:	return attack_x_offset43[curDir];
		case 44:	return attack_x_offset44[curDir];
	}

	err_here();
	return NULL;
}
//----------- End of function UnitArray::get_target_x_offset -----------//


//--------- Begin of function UnitArray::get_target_y_offset ---------//
// return y offset
//
// <int>		targetWidth		- width of the target
// <int>		targetHeight	- height of the target
//	<char>	curDir			- the direction of attacker to the target
//
char* UnitArray::get_target_y_offset(int targetWidth, int targetHeight, char curDir)
{
	err_when(curDir<0 || curDir>ATTACK_DIR);
	int targetType = targetWidth*10 + targetHeight;
	switch(targetType)
	{
		case 11:	return attack_y_offset11[curDir];
		case 12:	return attack_y_offset12[curDir];
		case 13:	return attack_y_offset13[curDir];
		case 14:	return attack_y_offset14[curDir];
		case 21:	return attack_y_offset21[curDir];
		case 22:	return attack_y_offset22[curDir];
		case 23:	return attack_y_offset23[curDir];
		case 24:	return attack_y_offset24[curDir];
		case 31:	return attack_y_offset31[curDir];
		case 32:	return attack_y_offset32[curDir];
		case 33:	return attack_y_offset33[curDir];
		case 34:	return attack_y_offset34[curDir];
		case 41:	return attack_y_offset41[curDir];
		case 42:	return attack_y_offset42[curDir];
		case 43:	return attack_y_offset43[curDir];
		case 44:	return attack_y_offset44[curDir];
	}

	err_here();
	return NULL;
}
//----------- End of function UnitArray::get_target_y_offset -----------//
